/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.org.quartz;

import java.text.ParseException;
import java.util.TimeZone;
import net.creeperhost.ftbbackups.org.quartz.CronExpression;
import net.creeperhost.ftbbackups.org.quartz.CronTrigger;
import net.creeperhost.ftbbackups.org.quartz.DateBuilder;
import net.creeperhost.ftbbackups.org.quartz.ScheduleBuilder;
import net.creeperhost.ftbbackups.org.quartz.impl.triggers.CronTriggerImpl;
import net.creeperhost.ftbbackups.org.quartz.spi.MutableTrigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CronScheduleBuilder
extends ScheduleBuilder<CronTrigger> {
    private String cronExpression;
    private TimeZone tz;
    private int misfireInstruction = 0;

    private CronScheduleBuilder(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    @Override
    public MutableTrigger build() {
        CronTriggerImpl ct = new CronTriggerImpl();
        try {
            ct.setCronExpression(this.cronExpression);
        }
        catch (ParseException e) {
            throw new RuntimeException("CronExpression '" + this.cronExpression + "' is invalid, which should not be possible, please report bug to Quartz developers.");
        }
        ct.setTimeZone(this.tz);
        ct.setMisfireInstruction(this.misfireInstruction);
        return ct;
    }

    public static CronScheduleBuilder cronSchedule(String cronExpression) throws ParseException {
        CronExpression.validateExpression(cronExpression);
        return new CronScheduleBuilder(cronExpression);
    }

    public static CronScheduleBuilder dailyAtHourAndMinute(int hour, int minute) {
        DateBuilder.validateHour(hour);
        DateBuilder.validateMinute(minute);
        String cronExpression = String.format("0 %d %d ? * *", minute, hour);
        return new CronScheduleBuilder(cronExpression);
    }

    public static CronScheduleBuilder weeklyOnDayAndHourAndMinute(int dayOfWeek, int hour, int minute) {
        DateBuilder.validateDayOfWeek(dayOfWeek);
        DateBuilder.validateHour(hour);
        DateBuilder.validateMinute(minute);
        String cronExpression = String.format("0 %d %d ? * %d", minute, hour, dayOfWeek);
        return new CronScheduleBuilder(cronExpression);
    }

    public static CronScheduleBuilder monthlyOnDayAndHourAndMinute(int dayOfMonth, int hour, int minute) {
        DateBuilder.validateDayOfMonth(dayOfMonth);
        DateBuilder.validateHour(hour);
        DateBuilder.validateMinute(minute);
        String cronExpression = String.format("0 %d %d %d * ?", minute, hour, dayOfMonth);
        return new CronScheduleBuilder(cronExpression);
    }

    public CronScheduleBuilder inTimeZone(TimeZone tz) {
        this.tz = tz;
        return this;
    }

    public CronScheduleBuilder withMisfireHandlingInstructionIgnoreMisfires() {
        this.misfireInstruction = -1;
        return this;
    }

    public CronScheduleBuilder withMisfireHandlingInstructionDoNothing() {
        this.misfireInstruction = 2;
        return this;
    }

    public CronScheduleBuilder withMisfireHandlingInstructionFireAndProceed() {
        this.misfireInstruction = 1;
        return this;
    }
}

